#!/bin/bash

# abort whenever an error occurs
set -e

if [ -z "$NEXTCLOUD_VERSION" ]
then
    echo "No nextcloud version set, using version in file"
    export NEXTCLOUD_VERSION=$(cat NEXTCLOUD_VERSION | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
    echo "Found version: ${NEXTCLOUD_VERSION}"
fi

if [ -z "$NEXTCLOUD_VERSION" ]
then
    echo "Error: No nextcloud version set!"
    exit 1
fi

# Cleanup old client dirs
rm -rf client

echo "Checking out nextcloud client version: ${NEXTCLOUD_VERSION}"

# Clone the desktop client code
git clone --recursive https://github.com/nextcloud/desktop.git client
cd client

git checkout ${NEXTCLOUD_VERSION}
git submodule update --recursive

cd ..