#!/usr/bin/env bash

set -o xtrace
set -e

export HOME=/home/builduser
SIGNKEY="${SIGNKEY:-"Repository"}"

echo "Importing signing key"
${REPODIR}/linux/import-gpg-key ${REPODIR}/linux/repository.key

# Build the package
cd ${REPODIR}/client

echo "Starting build"

if [ $CI_COMMIT_REF_NAME != "master" ]; then
    makepkg -s --noconfirm
    echo "Not on master, quitting"
    exit 0
fi

makepkg -s --key ${SIGNKEY} --noconfirm

echo "Creating repo"

mkdir ${REPODIR}/repo
mv ${REPODIR}/client/*.pkg.tar.xz ${REPODIR}/repo/

# Create the repository
repo-add -s -k ${SIGNKEY} ${REPODIR}/repo/stack.db.tar ${REPODIR}/repo/*.pkg.tar.xz