#!/usr/bin/env bash

set -o xtrace
set -e

# Add the repo key
pacman-key --add ${REPODIR}/linux/repository.key

# https://www.reddit.com/r/archlinux/comments/6qu4jt/how_to_run_makepkg_in_docker_container_yes_as_root/

# Create the builduser
useradd builduser -m

# Delete the buildusers password
passwd -d builduser

# Allow the builduser passwordless sudo
printf 'builduser ALL=(ALL) ALL\n' | tee -a /etc/sudoers
printf 'root ALL=(ALL) ALL\n' | tee -a /etc/sudoers

# Install packages
pacman -Sy --needed --noconfirm \
        openssl sqlite qtkeychain qt5-svg qt5-webengine xdg-utils libcloudproviders \
        doxygen extra-cmake-modules kio python-sphinx qt5-tools git cmocka \
        kio nemo-python python-nautilus python2-caja sudo base-devel expect

cat linux/arch/PKGBUILD \
    | sed "s@%VERSION%@${NEXTCLOUD_VERSION:1}@g" \
    | sed "s@%BUILDID%@${BUILDID}@g" \
    | sed "s@%THEMEDIR%@${REPODIR}/stacktheme@g" \
    | sed "s@%REPODIR%@${REPODIR}@g" \
    | sed "s@%CLIENTDIR%@${REPODIR}/client@g" \
    > client/PKGBUILD

# Fix permissions
chown -R builduser:builduser client

echo "==== PKGBUILD CONFIG ===="
cat client/PKGBUILD
echo "==== PKGBUILD CONFIG ===="

# Clone and build a package
sudo -u builduser -E ${REPODIR}/linux/arch/build.sh
