#!/usr/bin/env bash

set -e

apt-get update

apt-get install -y git libsqlite3-dev qt5-default qt5-default openssl libssl-dev libzip-dev qtdeclarative5-dev \
                   libqt5webkit5-dev qtwebengine5-dev qt5keychain-dev qttools5-dev sqlite3 libsqlite3-dev \
                   libqt5svg5-dev zlib1g-dev cmake build-essential devscripts debhelper \
                   python3-sphinx doxygen libkf5kjs-dev libcmocka-dev libhttp-dav-perl optipng pkg-kde-tools  \
                   python3-all qttools5-dev-tools xvfb cdbs extra-cmake-modules dolphin-dev python-nautilus \
                   libdbus-1-dev

# Allow this to fail, optional dependency
apt-get install -y libcloudproviders-dev || :

if [ "${DEBIAN_VERSION}" == "eoan" ]; then
    apt-get install -y libkf5kio-dev
elif [ "${DEBIAN_VERSION}" == "focal" ]; then
    apt-get install -y libkf5kio-dev dh-python
else
    apt-get install -y kdelibs5-dev kio-dev
fi

cd $REPODIR

export CLIENT_DIR=stack-client_${NEXTCLOUD_VERSION}

mkdir -p ${CLIENT_DIR}/debian
cp -R client ${CLIENT_DIR}/client
cp -R stacktheme ${CLIENT_DIR}
rm -Rf ${CLIENT_DIR}/binary
cp -r linux/debian/* ${CLIENT_DIR}/debian/

# Allow this one to fail, as xenial has no directory
cp -r linux/debian.${DEBIAN_VERSION}/* ${CLIENT_DIR}/debian/

cd ${CLIENT_DIR}

#EDITOR=true dpkg-source --commit . local-changes

debuild --preserve-env -i -us -uc -nc -b
