#
# spec file for package [% shortname %]-client
#
# Copyright (c) 2012-2016 ownCloud GmbH; Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes, issues or comments via http://github.com/owncloud/
#

## Caution: This spec file exists in multiple locations. Keep in sync:
##  isv:ownCloud:desktop
##  isv:ownCloud:community:nightly
##  isv:ownCloud:community:testing
##  github.com/owncloud/administration/jenkins/obs_integration/templates/client/v1_8_1/SHORTNAME-client.spec.in
##  -> you can modify it in testing, and play around for a while, but then merge into the copy on
##     github, which is authorative for the branded clients.
##
## [% create_msg %]

## One specfile to rule them all:
##  versions 1.6.x or 1.7.x, released or prerelease versions. All rpm based platforms.
##  testing, branding, whatever.
##
## Caution: do not change the names of the following three defines.
## prerelease, base_version, tar_version are the interface into buildpackage.pl
## used in rotor.o.c job owncloud-client-linux
## define prerelease as nil, if this is not a prerelease.
%define prerelease [% prerelease %]
%define base_version [% version %]
%define tar_version %{base_version}%{prerelease}

Name:           [% shortname %]-client

%if "%{name}" == "owncloud-client"
%define is_owncloud_client 1
%else
%define is_owncloud_client 0
%endif

# Use translations from an external tarball in the package, or build them
# using the Qt tools? For distros where we do not have the tools, disable.

%if 0%{?centos_version} == 600 || 0%{?rhel_version} == 600 || 0%{?fedora_version} || "%{prerelease}" == ""
# For beta and rc versions we use the ~ notation, as documented in
# http://en.opensuse.org/openSUSE:Package_naming_guidelines
# Some distro's (centos_6) don't allow ~ characters. There we follow the Fedora guidelines,
# which suggests massaging the buildrelease number.
# Otoh: for openSUSE, this technique is discouraged by the package naming guidelines.
Version:       	%{base_version}
%if "%{prerelease}" == ""
Release:        0
%else
Release:       	0.<CI_CNT>.<B_CNT>.%{prerelease}
%endif
%else
Version:       	%{base_version}~%{prerelease}
Release:        0
%endif

License:        GPL-2.0 and GPL-2.0+ and LGPL-2.1+
Summary:        [% summary %]
Url:            [% projecturl %]
Group:          Productivity/Networking/Other
Source0:        [% tarball %].tar.bz2
Source1:        [% APPLICATION_EXECUTABLE %].sh
Source2:        [% APPLICATION_EXECUTABLE %]cmd.sh
Source3:        100-sync-inotify.conf
Source4:        l10n.zip

Patch1:         autostart_use_wrapper.diff

%if 0%{?rhel_version} >= 600 || 0%{?centos_version} >= 600 || 0%{?suse_version} == 1110 || 0%{?fedora_version} == 23
%if 0%{?suse_version} == 1110
# SLES 11 calls make_install makeinstall
%define make_install %{makeinstall}
%endif
# We need a more recent, prefixed Qt for SLE11
%define opt_hack 1
%define qtprefix opt-
%if 0%{?rhel_version} == 600 || 0%{?centos_version} == 600
%define optdir /opt/qt-4.8
%else
%define optdir /opt/qt-5.4
%endif

# Must be all in one line:
%define cmake_args -DCMAKE_INCLUDE_PATH=%{_prefix}/include -DCMAKE_LIBRARY_PATH=%{_prefix}/%{_lib} -DCMAKE_INSTALL_RPATH_USE_LINK_PATH=TRUE -DWITH_CRASHREPORTER=OFF -DNO_SHIBBOLETH=1
%else
%define opt_hack 0
%define qtprefix %{nil}
%define cmake_args -DSYSCONF_INSTALL_DIR=%{_sysconfdir}
%endif

# default to have no docs. Cannot be built with old distros.
%define have_doc 0

# prepare stuff for qt5
# If Qt5 is available, we use it. Also, if the Qt-Version is 5.4 or higher
%define use_qt5 1
%define build_dolphin_overlays 1

# Use Qt5 if
# - OpenSUSE is > 13.1 (needs to include 1315 for 42.1!, hence "> 1310")
#   - But not SLE (re-evaluate with SLE 13)
# - Fedora >= 20
# - RHEL or CentOS >= 7.0
%define suse_has_qt5 0
%if 0%{?is_opensuse} || 0%{?suse_version} == 1320 || 0%{?sle_version} >= 120200
  %define suse_has_qt5 1
%endif

%if 0%{?suse_has_qt5} || 0%{?fedora_version} > 20 || 0%{?rhel_version} >= 700 || 0%{?centos_version} >= 700
  %define use_qt5 1

  # On top of the Qt5 requirement, Dolphin plugin interface can only work on distros with KDE Applications >= 15.12
  # This we make sure to allow building not for OpenSUSE Leap 42.1 GA, not for 13.2
  # Leap_Updates would allow a dolphin overlay to work, this is not handled below.
  # the third term below is for leap 42.2
  %if 0%{?suse_version} > 1320 || 0%{?fedora_version} > 23 || (0%{?sle_version} >= 120200 && 0%{?is_opensuse})
    %define build_dolphin_overlays 1
  %endif
  %if "%_repository" == "openSUSE_Leap_42.1_Update"
    # It builds the overlay, despite this warning: Dolphin plugin disabled: KDE Frameworks 5.16 not found
    %define build_dolphin_overlays 1
  %endif
%endif

# The infamous SUSE matrix:
# -------------------------
#
#                      	is_opensuse 	suse_version	sle_version
# openSUSE_13.1				1310
# SLE_12				1315		120000
# SLE_12_SP1				1315		120100
# openSUSE_Leap_42.1	1		1315		120100
# openSUSE_13.2				1320
# openSUSE_Factory	1		1330
# openSUSE_Tumbleweed	1		1330


######################################################################### BuildRequires only below here.

BuildRequires:  cmake3 >= 2.8.11
BuildRequires:  gcc gcc-c++

# This is for all modern Fedora and CentOS 7
# These ship Qt in a decent version and do not need the opt-hack
%if 0%{?fedora_version} >= 21 || 0%{?centos_version} >= 700 || 0%{?rhel_version} == 700

%if %use_qt5
%if 0%{?fedora_version} == 23
# Fedora_23 has an unusable qt5-qttools-devel package. It complains
# "nothing provides qt5-designer qt5-linguist needed by qt5-qttools-devel"
# while Fedora_22 and Fedora_21 are happy with their qt5-qttools-devel.
BuildRequires:  qt5-qttools-libs-designercomponents qt5-qttools-libs-designer
# needed on Fedora-24 for KF5-KIO to be recognized by cmake:
BuildRequires:  extra-cmake-modules
%else
BuildRequires:  %{qtprefix}qt5-qttools-devel
%endif
# we need qt5 >= 5.5.1 https://github.com/owncloud/client/issues/5432
BuildRequires:  %{qtprefix}qt5-qtbase
BuildRequires:  %{qtprefix}qt5-qtbase-devel
BuildRequires:  %{qtprefix}qt5-qtbase-gui
BuildRequires:  %{qtprefix}qt5-qtwebkit-devel

%if %build_dolphin_overlays
BuildRequires:  extra-cmake-modules
BuildRequires:  kf5-kio-devel
%endif

%else # no qt5
BuildRequires:  qt4 qt4-devel >= 4.7
BuildRequires:  qtwebkit >= 2.2
BuildRequires:  qtwebkit-devel >= 2.2
%endif

BuildRequires:  openssl-devel
BuildRequires:  inetd desktop-file-utils
%else
# This is for all SUSE and RHEL6 and CentOS 6
%if %use_qt5

# we need qt5 >= 5.5.1 https://github.com/owncloud/client/issues/5432
#BuildRequires:  libQt5Core-devel
#BuildRequires:  libQt5Gui-devel
#BuildRequires:  libQt5Network-devel
#BuildRequires:  libQt5WebKitWidgets-devel
#BuildRequires:  libQt5Xml-devel
#BuildRequires:  libQt5PrintSupport-devel
#BuildRequires:  libQt5DBus-devel
#BuildRequires:  libQt5Concurrent-devel
#BuildRequires:  libqt5-linguist-devel

%if %build_dolphin_overlays
BuildRequires:  kf5-kio-devel
%endif

%else # no qt5

BuildRequires:  %{qtprefix}libqt4-devel >= 4.7
BuildRequires:  %{qtprefix}libQtWebKit-devel
BuildRequires:  %{qtprefix}libQtWebKit4

%endif

%endif

# SUSE specific stuff
%if 0%{?suse_version}
BuildRequires:  update-desktop-files
BuildRequires:  libopenssl-devel
%endif

# https://github.com/owncloud/client/issues/2153
%define have_man 0

# Version independant package name mapping between suse and fedora/centos
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
BuildRequires:  sqlite-devel
BuildRequires:  inetd desktop-file-utils
%else
BuildRequires:  libsqlite3x-devel
BuildRequires:  desktop-file-utils
%endif


######################################################################### Requires only below here.

%if %use_qt5 && 0%{?suse_version} == 0
# suse finds the libs via autoreqprov
# https://github.com/owncloud/client/issues/4431

# we need qt5 >= 5.5.1 https://github.com/owncloud/client/issues/5432
Requires:       %{qtprefix}qt5-qtbase
Requires:       %{qtprefix}qt5-qtbase-gui
# libQtWebKit4 is implicitly pulled by libowncloudsync0
Requires:       %{qtprefix}qt5-qtwebkit
# libqt4-sql is implicitly pulled by libqt4-sql-sqlite
%endif
%if 0%{?fedora_version} > 20 || 0%{?centos_version} > 700 || 0%{?suse_version} || 0%{?rhel_version} > 700
# Fedora-19 and -20, CentOS-6, CentOS-7, RHEL_6,7 don't have Suggests.
Suggests:	%{name}-nautilus
Suggests:       %{name}-nemo
Suggests:       %{name}-caja
%endif

%if 0%{?rhel_version} == 600 || 0%{?centos_version} == 600
# https://github.com/owncloud/client/issues/4400#issuecomment-176686729
Requires:	%{qtprefix}libqt4-sql
# https://github.com/owncloud/client/issues/4560
Requires:	%{qtprefix}libqt4
Requires:	%{qtprefix}libqt4-x11
%endif

Requires: %{name}-l10n
Requires: lib[% shortname %]sync0 = %{version}

######################################################################### Obsoletes only below here.

Obsoletes: libocsync0
Obsoletes: libocsync-devel
Obsoletes: libocsync-plugin-[% shortname %]
Obsoletes: libocsync-plugin-[% APPLICATION_EXECUTABLE %]
Obsoletes: libocsync-devel-doc
Obsoletes: libocsync-doc
Obsoletes: opt-[% APPLICATION_EXECUTABLE %]-client

# Obsolete the experimental Qt5 packages if this is the unbranded client.
%if %{is_owncloud_client}
Obsoletes: libowncloudqt5sync0 libowncloudqt5sync-devel owncloud-client-qt5 owncloud-client-qt5-doc owncloud-client-qt5-l10n
%endif

######################################################################### Package Descriptions start here.

BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
[% pkgdescription %]

%package -n %{name}-doc
Summary:        Documentation for [% displayname %]
Group:          Development/Libraries/C and C++
Requires: %{name}%{?_isa} = %{version}-%{release}
Obsoletes:      opt-%{name}-doc

%description -n %{name}-doc
Documentation for the [% displayname %] desktop application.

%package -n %{name}-l10n
Summary:        Localization for [% displayname %]
Group:          Development/Libraries/C and C++
Requires: %{name}%{?_isa} = %{version}-%{release}
Obsoletes:      opt-%{name}-l10n

%description -n %{name}-l10n
Localization files for the [% displayname %] desktop application.

%package -n lib[% shortname %]sync0
Obsoletes:      opt-lib[% shortname %]sync0

Summary:        The [% displayname %] synchronization library
Group:          Development/Libraries/C and C++

%description -n lib[% shortname %]sync0
The [% displayname %] synchronization library.

%package -n lib[% shortname %]sync-devel
Summary:        Development files for the [% displayname %] synchronization library
Group:          Development/Libraries/C and C++
Requires: lib[% shortname %]sync0 = %{version}
Obsoletes:      opt-lib[% shortname %]sync-devel

%description -n lib[% shortname %]sync-devel
Development files for the [% displayname %] synchronization library.

%package -n %{name}-nautilus
Summary:        Nautilus overlay icons
Group:          Productivity/Networking/Other
Requires:       nautilus
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
Requires:       nautilus-python
%else
Requires:       nautilus-python
%endif
Requires:       %{name}%{?_isa} = %{version}-%{release}
Obsoletes:      opt-%{name}-nautilus

%description -n %{name}-nautilus
This package provides overlay icons to visualize the synchronization state
in the Nautilus file manager.

%package -n %{name}-nemo
Summary:        Nemo overlay icons
Group:          Productivity/Networking/Other
Requires:       nemo
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
Requires:       nemo-python
%else
Requires:       python-nemo
%endif
Requires:       %{name}%{?_isa} = %{version}-%{release}
Obsoletes:      opt-%{name}-nemo

%description -n %{name}-nemo
This package provides overlay icons to visualize the synchronization state
in the Nemo file manager.

%package -n %{name}-caja
Summary:        Caja overlay icons
Group:          Productivity/Networking/Other
Requires:       caja
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
Requires:       caja-python
%else
Requires:       python-caja
%endif
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description -n %{name}-caja
This package provides overlay icons to visualize the synchronization state
in the Caja file manager.

%if 0%{build_dolphin_overlays}
%package -n %{name}-dolphin
Summary:        Dolphin overlay icons
Group:          Productivity/Networking/Other
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
Requires:       dolphin
%else
Requires:       dolphin
%endif
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description -n %{name}-dolphin
This package provides the neccessary plugin libraries for the KDE
Framework 5 based Dolphin filemanager to display overlay icons.

%endif

%prep
%setup -q -n [% tarball %]
%if 0%{?rhel_version} || 0%{?centos_version} || 0%{?suse_version} == 1110
# autostart_use_wrapper.diff
%patch1 -p1
%endif

%if 0%{?rhel_version} == 600 || 0%{?centos_version} == 600
sed -i -e 's/OVERRIDE=override/OVERRIDE=/' cmake/modules/QtVersionAbstraction.cmake
%endif

%build
echo centos_version 0%{?centos_version}
echo rhel_version   0%{?rhel_version}
echo fedora_version 0%{?fedora_version}
echo suse_version   0%{?suse_version}

%if %opt_hack
%endif
export LD_LIBRARY_PATH=%{optdir}/%{_lib}
export PATH=%{optdir}/bin:$PATH

mkdir build
pushd build
# http://www.cmake.org/Wiki/CMake_RPATH_handling#Default_RPATH_settings
cmake3 .. -DWITH_DOC=FALSE \
  -DMIRALL_VERSION_BUILD="[% buildjobid %]" \
  -DKDE_INSTALL_USE_QT_SYS_PATHS=1 \
  -DCMAKE_C_FLAGS:STRING="%{optflags}" \
  -DCMAKE_CXX_FLAGS:STRING="%{optflags}" \
  -DCMAKE_SKIP_RPATH=OFF \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -DCMAKE_INSTALL_PREFIX=%{_prefix} \
  -DMIRALL_VERSION_SUFFIX="" \
%if %{_lib} == lib64
  -DLIB_SUFFIX=64 \
%endif
%if ! %{is_owncloud_client}
  -DOEM_THEME_DIR=[% themedir %] \
%endif
%if %{opt_hack}
%if 0%{?rhel_version} == 600 || 0%{?centos_version} == 600
  -DQTKEYCHAIN_INCLUDE_DIR=%{optdir}/include/qtkeychain \
  -DQTKEYCHAIN_LIBRARY=%{optdir}/%{_lib}/libqtkeychain.so \
%else
  -DQTKEYCHAIN_INCLUDE_DIR=%{optdir}/include/qt5keychain \
  -DQTKEYCHAIN_LIBRARY=%{optdir}/%{_lib}/libqt5keychain.so \
%endif
%endif
  %cmake_args

# documentation here?
if [ -e conf.py ];
then
  # for old cmake versions we need to move the conf.py.
  mv conf.py doc/
fi

env LD_RUN_PATH=%{_libdir}/[% APPLICATION_EXECUTABLE %]:%{_libdir}/[% shortname %] make %{?_smp_mflags} VERBOSE=1

make doc
popd

%install
pushd build
%make_install

if [ %{have_doc} != 0 ];
then
  mkdir -p ${RPM_BUILD_ROOT}%{_docdir}/%{name}
  mv ${RPM_BUILD_ROOT}/usr/share/doc/client/* ${RPM_BUILD_ROOT}%{_docdir}/%{name}
  rmdir ${RPM_BUILD_ROOT}/usr/share/doc/client
  rm ${RPM_BUILD_ROOT}%{_docdir}/%{name}/html/unthemed/.buildinfo || :
  mv ${RPM_BUILD_ROOT}%{_docdir}/%{name}/html/unthemed/* ${RPM_BUILD_ROOT}%{_docdir}/%{name}/html/ || :
  rmdir ${RPM_BUILD_ROOT}%{_docdir}/%{name}/html/unthemed || :
fi
popd

%if %{have_man}
if [ -d ${RPM_BUILD_ROOT}%{_mandir}/man1 ]; then
%if ! %{is_owncloud_client}
  mkdir -p ${RPM_BUILD_ROOT}%{_mandir}man1
  mv ${RPM_BUILD_ROOT}%{_mandir}/man1/{owncloud.1,[% APPLICATION_EXECUTABLE %].1}
  mv ${RPM_BUILD_ROOT}%{_mandir}/man1/{owncloudcmd.1,[% APPLICATION_EXECUTABLE %]cmd.1}
%endif
  gzip ${RPM_BUILD_ROOT}%{_mandir}/man1/*.1
fi
%else
rm -f ${RPM_BUILD_ROOT}%{_mandir}/man1/*.1
%endif

%define extdir ${RPM_BUILD_ROOT}%{_datadir}/nautilus-python/extensions
test -f %{extdir}/ownCloud.py  && mv %{extdir}/ownCloud.py  %{extdir}/[% APPLICATION_EXECUTABLE %].py  || true
test -f %{extdir}/ownCloud.pyo && mv %{extdir}/ownCloud.pyo %{extdir}/[% APPLICATION_EXECUTABLE %].pyo || true
test -f %{extdir}/ownCloud.pyc && mv %{extdir}/ownCloud.pyc %{extdir}/[% APPLICATION_EXECUTABLE %].pyc || true

%if %opt_hack
install -d ${RPM_BUILD_ROOT}/%{optdir}/bin
mv ${RPM_BUILD_ROOT}/%{_bindir}/[% APPLICATION_EXECUTABLE %]* ${RPM_BUILD_ROOT}/%{optdir}/bin/

install %{SOURCE1} ${RPM_BUILD_ROOT}/usr/bin/[% APPLICATION_EXECUTABLE %]
install %{SOURCE2} ${RPM_BUILD_ROOT}/usr/bin/[% APPLICATION_EXECUTABLE %]cmd
%endif

# https://github.com/owncloud/client/issues/4107
install -m 0755 -D %{SOURCE3} ${RPM_BUILD_ROOT}/etc/sysctl.d/100-sync-inotify.conf

%if %{?suse_version:1}0
%suse_update_desktop_file -n [% APPLICATION_EXECUTABLE %]
# workaround for https://github.com/owncloud/ownbrander/issues/322
for desktop_icon_dir in $RPM_BUILD_ROOT/usr/share/icons/hicolor/*/apps; do
  # copy shortname to executable name, if missing.
  if [ -f $desktop_icon_dir/[% shortname %].png -a ! -f $desktop_icon_dir/[% APPLICATION_EXECUTABLE %].png ]; then
    cp $desktop_icon_dir/[% shortname %].png $desktop_icon_dir/[% APPLICATION_EXECUTABLE %].png
  fi
done
%endif

%if 0%{?fedora_version}
%post
/bin/touch --no-create %{_datadir}/icons/hicolor >/dev/null 2>/dev/null || :

%postun
if [ $1 -eq 0 ] ; then
    /bin/touch --no-create %{_datadir}/icons/hicolor >/dev/null  2>/dev/null
    /usr/bin/gtk-update-icon-cache %{_datadir}/icons/hicolor >/dev/null 2>/dev/null || :
fi
%endif

%posttrans
# fixing https://github.com/owncloud/enterprise/issues/1714
/usr/bin/gtk-update-icon-cache --quiet --force %{_datadir}/icons/hicolor >/dev/null 2>/dev/null || :

%post   -n lib[% shortname %]sync0 -p /sbin/ldconfig
%postun -n lib[% shortname %]sync0 -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%{_bindir}/[% APPLICATION_EXECUTABLE %]
%{_bindir}/[% APPLICATION_EXECUTABLE %]cmd

%if %{opt_hack}
%{optdir}/bin/[% APPLICATION_EXECUTABLE %]
%{optdir}/bin/[% APPLICATION_EXECUTABLE %]cmd
%endif

%{_datadir}/applications/[% APPLICATION_EXECUTABLE %].desktop
%{_datadir}/icons/hicolor
%if 0%{have_man}
%{_mandir}/man1/[% APPLICATION_EXECUTABLE %]*
%endif

%if %opt_hack
/usr/share/icons/hicolor
/usr/share/applications/[% APPLICATION_EXECUTABLE %].desktop
/usr/bin/[% APPLICATION_EXECUTABLE %]
/usr/bin/[% APPLICATION_EXECUTABLE %]cmd
%endif
%config /etc/[% shortname_etc %]
# https://github.com/owncloud/client/issues/4107
%config /etc/sysctl.d/100-sync-inotify.conf

%files -n %{name}-doc
%defattr(-,root,root,-)
%doc README.md COPYING
%if 0%{have_doc}
%doc %{_docdir}/%{name}
%endif

%files -n %{name}-l10n
%defattr(-,root,root,-)
%if 0%{?fedora_version} != 23
# workaround for https://github.com/owncloud/client/issues/4987
%{_datadir}/[% APPLICATION_EXECUTABLE %]
%endif

%files -n lib[% shortname %]sync0
%defattr(-,root,root,-)
%{_libdir}/lib[% APPLICATION_EXECUTABLE %]sync.so.*
%{_libdir}/[% APPLICATION_EXECUTABLE %]/libocsync.so.*
%dir %{_libdir}/[% APPLICATION_EXECUTABLE %]

%files -n lib[% shortname %]sync-devel
%defattr(-,root,root,-)
%{_libdir}/lib[% APPLICATION_EXECUTABLE %]sync.so
%{_libdir}/[% APPLICATION_EXECUTABLE %]/libocsync.so
%{_includedir}/[% APPLICATION_EXECUTABLE %]sync/

%files -n %{name}-nautilus
%defattr(-,root,root,-)
# Fedora also has *.pyc and *.pyo files here.
%{_datadir}/nautilus-python/extensions/syncstate-*.py*
%dir %{_datadir}/nautilus-python
%dir %{_datadir}/nautilus-python/extensions/

%files -n %{name}-nemo
%defattr(-,root,root,-)
# Fedora also has *.pyc and *.pyo files here.
%{_datadir}/nemo-python/extensions/syncstate-*.py*
%dir %{_datadir}/nemo-python
%dir %{_datadir}/nemo-python/extensions/

%files -n %{name}-caja
%defattr(-,root,root,-)
# Fedora also has *.pyc and *.pyo files here.
%{_datadir}/caja-python/extensions/syncstate-*.py*
%dir %{_datadir}/caja-python
%dir %{_datadir}/caja-python/extensions/

%if 0%{build_dolphin_overlays}
%files -n %{name}-dolphin
%defattr(-,root,root,-)
%{_libdir}/*dolphinpluginhelper.so
%{_libdir}/qt5/plugins/kf5/overlayicon/*dolphinoverlayplugin.so
%{_libdir}/qt5/plugins/*dolphinactionplugin.so

%{_datadir}/kservices5/*dolphinactionplugin.desktop
%dir %{_libdir}/qt5/plugins/kf5/overlayicon
%endif # build_dolphin_overlays
%changelog
