#!/usr/bin/env bash

set -e

export CURDIR=$(pwd)

cd "${CURDIR}"

(
cat <<EOF
%_smp_mflags %( \
    [ -z "\$RPM_BUILD_NCPUS" ] \\\
        && RPM_BUILD_NCPUS="`/usr/bin/nproc 2>/dev/null || \\\
                             /usr/bin/getconf _NPROCESSORS_ONLN`"; \\\
    if [ "\$RPM_BUILD_NCPUS" -gt 16 ]; then \\\
        echo "-j16"; \\\
    elif [ "\$RPM_BUILD_NCPUS" -gt 3 ]; then \\\
        echo "-j\$RPM_BUILD_NCPUS"; \\\
    else \\\
        echo "-j3"; \\\
    fi )

%__arch_install_post \
    /usr/lib/rpm/check-buildroot
EOF
) > ${HOME}/.rpmmacros

echo "Rpmmacros:"

cat ${HOME}/.rpmmacros

mkdir -p rpmbuild/BUILD rpmbuild/RPMS rpmbuild/SOURCES rpmbuild/SPECS rpmbuild/SRPMS

echo "Preparing rpmbuild dir"

tar --exclude-vcs -cjf rpmbuild/SOURCES/stack-client.tar.bz2 client

cp linux/fedora/stack-client.spec rpmbuild/SPECS/stack-client.spec
cp linux/fedora/*.patch rpmbuild/SOURCES/
cp linux/fedora/*.xml rpmbuild/SOURCES/

echo "Starting build"

# Docker run command
rpmbuild -v -ba --define "_topdir ${CURDIR}/rpmbuild" --define "name stack" --define "themedir ${CURDIR}/stacktheme" --define "version ${NEXTCLOUD_VERSION}" rpmbuild/SPECS/stack-client.spec

echo "Listing RPMs:"

ls -alR rpmbuild/RPMS

