%global _hardened_build 1

Name:           stack-client
Version:        2.6.5
Release:        0%{?dist}
Summary:        The STACK Client

# This package spec is based on: https://koji.fedoraproject.org/koji/buildinfo?buildID=1492535

# -libs are LGPLv2+, rest GPLv2
License:        LGPLv2+ and GPLv2
Url:            https://transip.nl/stack
Source0:        stack-client.tar.bz2
Source1:        stack.appdata.xml
# The patch does 3 things:
#  - Depends on system lib for QtSingleApplication and QtLockedFile
#  - Remove the extraneous namespace when calling QtSingleApplication
#  - Fix a mismatch in the QtSingleApplication::messageReceived signal and the 
# Application::slotParseMessage slot
# These fix are needed because the system wide QtSingleApplication is slightly 
# different from the bundled one.
#Patch0:         %%{name}-%%{version}-syslibs.patch
Patch0:         0001-CloudProviders-Don-t-clear-the-_recentMenu-pointer.patch
Patch1:         0001-CloudProvider-Use-absolute-path-in-dbus-file.patch

BuildRequires:  check
BuildRequires:  cmake
BuildRequires:  desktop-file-utils
BuildRequires:  doxygen
BuildRequires:  pkgconfig(gio-2.0)
BuildRequires:  libcloudproviders-devel
BuildRequires:  libappstream-glib
BuildRequires:  neon-devel
BuildRequires:  openssl-devel
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  python3-sphinx
BuildRequires:  qtlockedfile-qt5-devel
BuildRequires:  qtkeychain-qt5-devel >= 0.7.0
BuildRequires:  qtsingleapplication-qt5-devel
BuildRequires:  qt5-qtbase
BuildRequires:  qt5-qtbase-devel
BuildRequires:  qt5-qtbase-gui
BuildRequires:  qt5-qtwebkit-devel
BuildRequires:  qt5-qtxmlpatterns-devel
BuildRequires:  qt5-qttools qt5-qttools-devel
BuildRequires:  qt5-qtwebengine-devel
BuildRequires:  qt5-qtsvg-devel
BuildRequires:  extra-cmake-modules
# Plasma 5 Dolphin integration
%if 0%{?fedora} >= 24 || 0%{?rhel} > 7
BuildRequires:  kf5-kio-devel
BuildRequires:  kf5-kcoreaddons-devel
BuildRequires:  kf5-rpm-macros
%endif
BuildRequires:  sqlite-devel
Requires:       %{name}-libs%{?_isa} = %{version}-%{release}
# concerning libgnome-keyring read https://bugzilla.redhat.com/show_bug.cgi?id=1652973
Requires:       libgnome-keyring

Provides: mirall = %{version}-%{release}
Obsoletes: mirall < 1.8.0

# Read https://bugzilla.redhat.com/show_bug.cgi?id=1651261
ExcludeArch: ppc64 ppc64le s390x

%description
The STACK client enables you to connect to your the STACK Server.
With it you can create folders in your home directory, and keep the contents
of those folders synced with the STACK server. Simply copy a file into
the directory and the STACK Client does the rest.


%package libs
Summary: Common files for stack-client
License: LGPLv2+
Provides: mirall-common = %{version}-%{release}
Obsoletes: mirall-common < 1.8.0
Requires: %{name}%{?_isa} = %{version}-%{release}

%description libs
Provides common files for stack-client such as the
configuration file that determines the excluded files in a sync.


%package devel
Summary: Development files for stack-client
License: LGPLv2+
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires: %{name}%{?_isa} = %{version}-%{release}
Provides: %{name}-static = %{version}-%{release}
Provides: mirall-devel = %{version}-%{release}
Obsoletes: mirall-devel < 1.8.0

%description devel
Development headers for use of the stack-client library

%package nautilus
Summary: stack client nautilus extension
Requires: nautilus
Requires: nautilus-python
Requires: %{name}%{?_isa} = %{version}-%{release}
Provides: mirall-nautilus = %{version}-%{release}
Obsoletes: mirall-nautilus < 1.8.0


%description nautilus
The stack desktop client nautilus extension.

%package nemo
Summary:        Nemo overlay icons
Requires:       nemo
Requires:       nemo-python
Requires: %{name}%{?_isa} = %{version}-%{release}

%description nemo
This package provides overlay icons to visualize the sync state
in the nemo file manager.

# Only Fedora has Mate, so there is no need for Caja extension on EPEL
%if 0%{?fedora}
%package caja
Summary:        Caja overlay icons
Requires:       caja
Requires:       python3-caja
Requires: %{name}%{?_isa} = %{version}-%{release}

%description caja
This package provides overlay icons to visualize the sync state
in the caja file manager.
%endif

%if 0%{?fedora} >= 24 || 0%{?rhel} > 7
%package dolphin
Summary:        Dolphin overlay icons
Requires:       dolphin
Requires: %{name}%{?_isa} = %{version}-%{release}

%description dolphin
The stack desktop client dolphin extension.
%endif

%prep
%setup -q -n client
#rm -rf src/3rdparty/qtlockedfile src/3rdparty/qtsingleapplication
%patch0 -p1
%patch1 -p1


%build
mkdir build
pushd build
%cmake_kf5 .. -DCMAKE_SHARED_LINKER_FLAGS="-Wl,--as-needed" -DOEM_THEME_DIR=%{themedir} -DWITH_CRASHREPORTER=OFF -DNO_SHIBBOLETH=1 -DCMAKE_SKIP_RPATH=OFF -DMIRALL_VERSION_SUFFIX=""
make %{?_smp_mflags}
popd


%install
pushd build
make install DESTDIR=%{buildroot}
popd
%find_lang client --with-qt
mkdir -p %{buildroot}%{_datadir}/appdata/
install -m 644 %{SOURCE1} %{buildroot}%{_datadir}/appdata/stack.appdata.xml


# for distros that do not have KDE Plasma 5
%if 0%{?fedora} < 24 && 0%{?rhel} <= 7
rm -f %{buildroot}%{_libdir}/libstackdolphinpluginhelper.so
rm -f %{buildroot}%{_kf5_plugindir}/overlayicon/stackdolphinoverlayplugin.so
rm -f %{buildroot}%{_qt5_plugindir}/stackdolphinactionplugin.so
rm -f %{buildroot}%{_kf5_datadir}/kservices5/stackdolphinactionplugin.desktop
%endif


# Only Fedora has Mate, so there is no need for Caja extension on EPEL
%if 0%{?rhel}
rm -rf %{buildroot}%{_datadir}/caja-python/
%endif


%check
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/appdata/stack.appdata.xml

%ldconfig_scriptlets libs

%if 0%{?fedora} >= 24 || 0%{?rhel} > 7
%ldconfig_scriptlets dolphin
%endif

%files -f client.lang
%{_bindir}/stack
%{_bindir}/stackcmd
%{_datadir}/applications/nl.transip.desktopclient.stack.desktop
%{_datadir}/icons/hicolor/*/apps/*
%{_datadir}/appdata/stack.appdata.xml
%{_datadir}/cloud-providers/com.transip.stack.ini
%{_datadir}/dbus-1/services/com.transip.stack.service

%files libs
%{_libdir}/libstacksync.so.0
%{_libdir}/libstacksync.so.%%{version}
%{_libdir}/stack/libocsync.so.*
%doc README.md
%config %{_sysconfdir}/stack/sync-exclude.lst
%dir %{_sysconfdir}/stack

%files devel
%{_includedir}/stacksync/
%{_libdir}/libstacksync.so
%{_libdir}/stack/libocsync.so

%files nautilus
%{_datadir}/nautilus-python/extensions/*

%files nemo
%{_datadir}/nemo-python/extensions/*

# Only Fedora has Mate, so there is no need for Caja extension on EPEL
%if 0%{?fedora}
%files caja
%{_datadir}/caja-python/extensions/*
%endif

%if 0%{?fedora} >= 24 || 0%{?rhel} > 7
%files dolphin
%{_libdir}/libstackdolphinpluginhelper.so
%{_kf5_plugindir}/overlayicon/stackdolphinoverlayplugin.so
%{_qt5_plugindir}/stackdolphinactionplugin.so
%{_kf5_datadir}/kservices5/stackdolphinactionplugin.desktop
%endif

%changelog
* Thu May 07 2020 TransIP BV <support@transip.nl> - 2.6.4.0-1
- Initial release