# Building for MacOS

## Dependencies

### Xcode

Install Xcode. Run `xcode-select --select`.

### MacOS SDK

Make sure you have the right MacOS SDK version installed (we currently use 10.14), which can be downloaded here:  https://github.com/phracker/MacOSX-SDKs
Move it to the SDKs directory for Xcode.

### Brew

Install brew: https://brew.sh/

Then install the packages:

- `brew install openssl@1.1`
- `brew install zlib`
- `brew install cmake`

### Packages

- Install Packages from: http://s.sudre.free.fr/Software/Packages/about.html

### Sparkle

Install Sparkle framework from: https://sparkle-project.org/

Instructions here: https://sparkle-project.org/documentation/ (without cocoapods!)

### QT

Install the QT open source edition from here: https://www.qt.io/
Choose a LTS release that is supported by Nextcloud.

### qtkeychain

Install qtkeychain from: https://github.com/frankosterfeld/qtkeychain/wiki#compilation-on-macos

After following these instructions, run `sudo make install` to install qtkeychain.

## Cloning and patching the sourcecode

Prepare building by checking out the right client version:

- Run `./clone.sh`
- Run `./patch.sh`

## Building

Start the build:

- Set other env variables you might want to override defined in `build.sh`.
- Run `macos/build.sh`

Sign the build and create the packages:

- Place the sparkle private key in the macos directory:
  - `cp /path/to/key macos/dsa_priv.key`
- Sign the application and create an installer by running:
  -  `macos/sign.sh <APP_CERT> <INSTALL_CERT> <USERNAME-FOR-NOTARIZING>`
  -  For TransIP:
  -  `macos/sign.sh "C661735E855AAB540E55753DF75AE30B06D96D35" "BE4EA73F73B6DC1137C9F86471461B41A7AA7565" "pvansanten@transip.nl"`
  -  (Make sure you use an app password for the Apple account)
- Now you will have to wait for the Apple notarization process to complete (you will receive an email from Apple when it does).
- After it completes successfully, run `macos/finish.sh`.
- The binaries are now ready for distribution in the `mac-install` directory.
