#!/bin/bash

set -e

BUILDID="${BUILDID:-$(date '+%Y%m%d')}"
REPODIR="${REPODIR:-$(pwd)}"
SPARKLE_FRAMEWORK="${SPARKLE_FRAMEWORK:-/Applications/Xcode.app/Contents/Frameworks/Sparkle.framework}"
MAC_SDK="${MAC_SDK:-/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.14.sdk}"
QT_DIR="${QT_DIR:-~/Qt/5.12.9}"
DEPLOY_TARGET="${DEPLOY_TARGET:-10.12}"
QT_CLANG="${QT_CLANG:-$QT_DIR/clang_64}"
CLIENT_DIR="${CLIENT_DIR:-$REPODIR/client}"
BUILD_DIR="${INSTALL_DIR:-$REPODIR/mac-build}"
INSTALL_DIR="${INSTALL_DIR:-$REPODIR/mac-install}"

export QTDIR=${QT_DIR}
export QT_BIN_DIR=${QT_DIR}/bin
export PATH=${QT_BIN_DIR}:$PATH

rm -rf ${INSTALL_DIR} ${BUILD_DIR}
mkdir -p ${INSTALL_DIR}
mkdir -p ${BUILD_DIR}

# Replace the sparkle cert
cp macos/dsa_pub.pem client/admin/osx/sparkle/

cd ${BUILD_DIR}

# Build the client
cmake -DCMAKE_OSX_SYSROOT="${MAC_SDK}" \
    -DCMAKE_OSX_DEPLOYMENT_TARGET=${DEPLOY_TARGET} \
    -DCMAKE_INSTALL_PREFIX=${INSTALL_DIR} \
    -DCMAKE_PREFIX_PATH=${QT_CLANG} \
    -DOPENSSL_ROOT_DIR=$(brew --prefix openssl) \
    -DZLIB_INCLUDE_DIR=$(brew --prefix zlib) \
    -DSPARKLE_INCLUDE_DIR=${SPARKLE_FRAMEWORK} \
    -DSPARKLE_LIBRARY=${SPARKLE_FRAMEWORK} \
    -DOEM_THEME_DIR=${REPODIR}/stacktheme \
    -DWITH_CRASHREPORTER=OFF \
    -DNO_SHIBBOLETH=1 \
    -DMIRALL_VERSION_BUILD=${BUILDID} \
    -DMIRALL_VERSION_SUFFIX="" \
    -DCMAKE_BUILD_TYPE=Release \
    -DBUILD_UPDATER=ON \
    ${CLIENT_DIR}

make -j4
make -j1 install

cd ${REPODIR}

echo "Build complete, run sign.sh to sign the build"
