#!/bin/bash

set -e

REPODIR="${REPODIR:-$(pwd)}"
INSTALL_DIR="${INSTALL_DIR:-$REPODIR/mac-install}"

PKG_FILE=$(find ${INSTALL_DIR} -maxdepth 1 -name '*.pkg')
UPDATE_FILE=$(find ${INSTALL_DIR} -maxdepth 1 -name '*.pkg.tbz')

echo "Stapling app"

xcrun stapler staple "${PKG_FILE}"

echo "Signing sparkle tgz update file"

# Generate a sparkle signature for the tbz
openssl dgst -sha1 -binary < ${INSTALL_DIR}/*.tbz | openssl dgst -dss1 -sign ${REPODIR}/macos/dsa_priv.pem | openssl enc -base64 > ${UPDATE_FILE}.sig

echo "Signing done, ready for distribution"
