#!/bin/bash

set -e

REPODIR="${REPODIR:-$(pwd)}"
CLIENT_DIR="${CLIENT_DIR:-$REPODIR/client}"
BUILD_DIR="${INSTALL_DIR:-$REPODIR/mac-build}"
INSTALL_DIR="${INSTALL_DIR:-$REPODIR/mac-install}"
QT_DIR="${QT_DIR:-/usr/local/opt/qt}"

APP_CERT=$1
INSTALL_CERT=$2
USERNAME=$3

echo "Signing app with ${APP_CERT}"

# The magic string here is SHA1 hash of your Developer ID Application certificate
${CLIENT_DIR}/admin/osx/sign_app.sh ${INSTALL_DIR}/stack.app ${APP_CERT}

echo "Creating pkg, signing with ${INSTALL_CERT}"

# The magic string here is SHA1 hash of your Developer ID Installer certificate
${BUILD_DIR}/admin/osx/create_mac.sh ${INSTALL_DIR} ${BUILD_DIR} ${INSTALL_CERT}

PKG_FILE=$(find ${INSTALL_DIR} -maxdepth 1 -name '*.pkg')

echo "Notarizing app"

xcrun altool --notarize-app -f "${PKG_FILE}" --primary-bundle-id nl.transip.Stack --username "${USERNAME}"

echo "Notarization request sent, please wait for Apple to complete the request, then run finish.sh"
