#!/bin/bash

# abort whenever an error occurs
set -e

echo "Applying TransIP patches"

cd client

# apply all patches
for file in ../patches/*; do echo "Applying patch ${file}" && patch -p1 < ${file}; done

cd ..

echo "Copying NSIS installer files for windows build"
# Because the windows installer build script does not use the custom theme directory
cp -R transiptheme/installer/nsi client/admin/win/

echo "Adapting theme"

mkdir -p stacktheme/theme
# Copy nextcloud theme files
cp -R client/theme/* stacktheme/theme
# Overwrite the STACK specific theme files
cp -R transiptheme/* stacktheme/

echo "Ready for build ID: ${BUILDID}"